﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WPF_LibrosFamosos
{
    public class CatalogoLibros
    {
        librosEntities3 contenedor = new librosEntities3();
        public List<autores> Autores
        {
            get { return contenedor.autores.OrderBy(x => x.Nombre).ToList(); }
        }

        public List<libros> LibrosAutor(int Idautor)
        {
             return contenedor.libros.Where(x => x.Autor == Idautor).ToList();
        }

        public libros InfLibro(int IdLibro)
        {
            return (from x in contenedor.libros where x.Id == IdLibro select x).FirstOrDefault() as libros ;
            //return contenedor.libros.Where(x => x.Id == IdLibro) as libros;
        }

        public string Reseña(int Idlibro)
        {
            string r;
            if (contenedor.resenhas.Any(x=>x.IdLibro==Idlibro))
            {
                r = contenedor.resenhas.FirstOrDefault(x => x.IdLibro == Idlibro).Resenha;
            }
            else
            {
                r = "El libro no contiene una reseña para ser mostrada";
            }
            return r;
        }

        public event Action ActualizarLista;
        public event Action ActualizarListaLibros;

        public void Agregar(autores autor)
        {
            if (contenedor.autores.Any(x=>x.Nombre==autor.Nombre))
            {
                throw new ArgumentException("El nombre del autor ya se encuentra registrado");
            }
            if (string.IsNullOrWhiteSpace(autor.Nombre))
            {
                throw new ArgumentException("El nombre del autor no puede estar vacio");
            }
            else
            {
                autores a = new autores
                {
                    Nombre = autor.Nombre,
                    Nacimiento = autor.Nacimiento,
                    Muerte = autor.Muerte,
                    Nacionalidad = autor.Nacionalidad
                };
                contenedor.autores.Add(a);
                contenedor.SaveChanges();
                ActualizarLista?.Invoke();
            }
        }

        public void Eliminar(autores autor)
        {
            if (autor==null)
            {
                throw new ArgumentException("Seleccione un autor existente");
            }
            if (contenedor.autores.Any(x=>x.IdAutor==autor.IdAutor))
            {
                if (autor.libros.Count!=0)
                {
                    List<libros> listalibros = (autor.libros).ToList();
                    for (int i = 0; i < listalibros.Count; i++)
                    {
                        if (listalibros[i].resenhas!=null)
                        {
                            resenhas r = listalibros[i].resenhas;
                            contenedor.resenhas.Remove(r);
                        }
                        contenedor.libros.Remove(listalibros[i]);
                    }
                }
                contenedor.autores.Remove(autor);
                contenedor.SaveChanges();
                ActualizarLista?.Invoke();
            }
        }
        public void Editar(autores autor)
        {
            if (autor == null)
            {
                throw new ArgumentException("Seleccione un autor");
            }
            if (contenedor.autores.Any(x => x.IdAutor == autor.IdAutor))
            {
                contenedor.SaveChanges();
                ActualizarLista?.Invoke();
            }
        }

        public void AgregarLibro(libros libro,resenhas resena)
        {
            if (contenedor.libros.Any(x=>x.TituloOriginal==libro.TituloOriginal))
            {
                throw new ArgumentException("El titulo original del libro ya existe.");
            }
            if (string.IsNullOrWhiteSpace(libro.TituloOriginal) || string.IsNullOrWhiteSpace(libro.Titulo))
            {
                throw new ArgumentException("El titulo ó titulo original no pueden ir vacios.");
            }
            else
            {
                libros lib = new libros { Titulo = libro.Titulo, TituloOriginal = libro.TituloOriginal, Autor = libro.Autor, Genero = libro.Genero };
                contenedor.libros.Add(lib);
                contenedor.SaveChanges();
                int id = contenedor.libros.FirstOrDefault(x => x.TituloOriginal == libro.TituloOriginal).Id;
                resenhas r = new resenhas { IdLibro=id,Resenha=resena.Resenha};
                contenedor.resenhas.Add(r);
                contenedor.SaveChanges();
                ActualizarListaLibros();
            }
        }

        public void EditarLibro(libros libro,resenhas resena)
        {
            resena.IdLibro = libro.Id;
            if (libro==null)
            {
                throw new ArgumentException("El libro no puede ir nulo.");
            }
            if (string.IsNullOrWhiteSpace(resena.Resenha) && contenedor.resenhas.Any(x=>x.IdLibro==resena.IdLibro))
            {
                contenedor.resenhas.Remove(resena);
            }
            resena.IdLibro = libro.Id;
            if (contenedor.libros.Any(c => c.Id == libro.Id) && resena.IdLibro==libro.Id)
            {
                if (!contenedor.resenhas.Any(x=>x.IdLibro==resena.IdLibro))
                {
                    contenedor.resenhas.Add(resena);
                }
                contenedor.SaveChanges();
                ActualizarListaLibros();
            }
        }

        public void EliminarLibro(libros l,resenhas r)
        {
            if (l==null)
            {
                throw new ArgumentException("El libro a eliminar en nulo.");
            }
            if (contenedor.libros.Any(x => x.Id == l.Id))
            {
                contenedor.resenhas.Remove(r);
                contenedor.libros.Remove(l);
                contenedor.SaveChanges();
                ActualizarListaLibros();
            }
        }
    }
}
